
#include "LEDs.h"
#include "p33Fxxxx.h"
#include "sine.h"
#include <string.h>

led_bright led_brightness[16], cur_led_brightness[16];
const led_bright* led_brightness_ptr;
unsigned short led_state;

void __attribute__((__interrupt__,no_auto_psv)) _SPI1Interrupt(void) {
	LATBbits.LATB5 = 1;
	IFS0bits.SPI1IF = 0;
}

static void set_leds(unsigned short val) {
	while( !LATBbits.LATB5 && !IFS0bits.SPI1IF )
		;
	if( IFS0bits.SPI1IF ) {
		LATBbits.LATB5 = 1;
		IFS0bits.SPI1IF = 0;
	}
	SPI1BUF = val|SPI1BUF;
	LATBbits.LATB5 = 0;
}

void __attribute__((__interrupt__,no_auto_psv)) _T5Interrupt(void) {
	T4CONbits.TON = 0;

	led_state = 0xFFFF;
	memcpy(cur_led_brightness, led_brightness, sizeof(cur_led_brightness));
	led_brightness_ptr = cur_led_brightness;
	while( led_brightness_ptr < cur_led_brightness + 16 && led_brightness_ptr[0].brightness == 0 ) {
		led_state &= ~(1<<led_brightness_ptr[0].index);
		++led_brightness_ptr;
	}
	set_leds(led_state);

	if( led_brightness_ptr < cur_led_brightness + 16 ) {
		PR4 = ((unsigned long)PR5 * (unsigned long)led_brightness_ptr[0].brightness) >> 8;
		if( PR4 < TMR5+4 )
			PR4 = TMR5+4;
		IFS1bits.T4IF = 0;
		TMR4 = TMR5;
		T4CONbits.TON = 1;
	}

	IFS1bits.T5IF = 0;
}

void __attribute__((__interrupt__,no_auto_psv)) _T4Interrupt(void) {
	unsigned char bright = led_brightness_ptr[0].brightness;
	T4CONbits.TON = 0;

	while( led_brightness_ptr < cur_led_brightness + 16 && led_brightness_ptr[0].brightness == bright ) {
		led_state &= ~(1<<led_brightness_ptr[0].index);
		++led_brightness_ptr;
	}
	set_leds(led_state);

	IFS1bits.T4IF = 0;
	if( led_brightness_ptr < cur_led_brightness + 16 ) {
		PR4 = ((unsigned long)PR5 * (unsigned long)(led_brightness_ptr[0].brightness)) >> 8;
		if( PR4 < TMR5+4 )
			PR4 = TMR5+4;
		TMR4 = TMR5;
		asm("disi #16");
		T4CONbits.TON = 1;
	}
}

void leds_init() {
	unsigned char i;
	for( i = 0; i < 16; ++i ) {
		cur_led_brightness[i].index = led_brightness[i].index = i;
	}

	// RA4 = SCLR (output, active high)
	TRISAbits.TRISA4 = 0;
	LATAbits.LATA4 = 1;

	// RB5 = RCK (output, open drain)
	ODCBbits.ODCB5 = 1;
	TRISBbits.TRISB5 = 0;
	LATBbits.LATB5 = 1;

	// RB6 = SER (output, open drain)
	ODCBbits.ODCB6 = 1;
	TRISBbits.TRISB6 = 0;
	LATBbits.LATB6 = 1;

	// RB8 = SCK (output, open drain)
	ODCBbits.ODCB8 = 1;
	TRISBbits.TRISB8 = 0;
	LATBbits.LATB8 = 1;

	// set up SPI to update LED state
	RPOR3bits.RP6R = 7; // SPI1 Data Output
	RPOR4bits.RP8R = 8; // SPI1 Clock Output
	SPI1CON1bits.PPRE = 1; // divide by 16
	SPI1CON1bits.SPRE = 8-1;//8-2; // divide by 2
	SPI1CON1bits.MSTEN = 1; // Master mode
	SPI1CON1bits.CKP = 0; // idle clock low
	SPI1CON1bits.CKE = 1; // change data on high to low transistion (active to idle)
	SPI1CON1bits.MODE16 = 1;

	// TMR5 used for 200Hz PWM update
	// TMR4 used for triggering updates within each 5ms interval
	T5CONbits.TCKPS = 1;
	T5CONbits.TON = 1;
	T4CONbits.TCKPS = 1;
	IFS1bits.T4IF = 0;

	IEC1bits.T5IE = 1;
	IEC1bits.T4IE = 1;
	IEC0bits.SPI1IE = 1;

	SPI1STATbits.SPIEN = 1;
	LATAbits.LATA4 = 0;
}

void leds_off() {
	LATAbits.LATA4 = 0;
	T5CONbits.TON = 0;
	T4CONbits.TON = 0;
	set_leds(0);
	while( !LATBbits.LATB5 )
		;
	SPI1STATbits.SPIEN = 0;
}
